/*
 * Decompiled with CFR 0.152.
 */
package jp.jias.bukkit.bossmonster;

import java.util.Random;
import java.util.logging.Logger;
import jp.jias.bukkit.bossmonster.BossEffect;
import jp.jias.bukkit.bossmonster.MachinegunShot;
import jp.jias.bukkit.bossmonster.ShowerShot;
import jp.jias.bukkit.bossmonster.Skill;
import jp.jias.bukkit.bossmonster.ThrowPotion;
import jp.jias.bukkit.bossmonster.TornadoShot;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BossMonster
extends JavaPlugin
implements Listener {
    private static Random rand = new Random();
    private static final String HEALTHGAUGE = "||||||||||";
    private Creature boss = null;
    private Skill skill = null;
    private int level;
    private Logger log;

    public void onEnable() {
        this.log = this.getLogger();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
        if (this.boss != null && !this.boss.isDead()) {
            Bukkit.broadcastMessage((String)(ChatColor.GOLD + "\u90aa\u60aa\u306a\u5b58\u5728\u306f\u59ff\u3092\u6d88\u3057\u305f\u2026"));
            this.boss.remove();
            this.boss = null;
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (!(sender instanceof Player)) {
            this.log.warning("\u3053\u306e\u30b3\u30de\u30f3\u30c9\u306f\u30b2\u30fc\u30e0\u306b\u30ed\u30b0\u30a4\u30f3\u3057\u305f\u30ad\u30e3\u30e9\u30af\u30bf\u30fc\u304c\u5b9f\u884c\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return true;
        }
        if (commandLabel.equalsIgnoreCase("boss")) {
            if (this.boss != null) {
                this.boss.teleport(((Player)sender).getLocation());
                this.boss.getWorld().playSound(this.boss.getLocation(), Sound.PORTAL, 100.0f, 1.0f);
                sender.sendMessage(ChatColor.GOLD + "\u30dc\u30b9\u3092\u3042\u306a\u305f\u306e\u5834\u6240\u306b\u79fb\u52d5\u3055\u305b\u307e\u3057\u305f\u3002");
                return true;
            }
            this.level = 1;
            if (args.length == 1) {
                try {
                    this.level = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(ChatColor.GOLD + "\u96e3\u6613\u5ea6\u306f\u6570\u5024\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    return false;
                }
                if (this.level < 0) {
                    this.level = 1;
                } else if (this.level > 50) {
                    this.level = 50;
                }
            }
            this.boss = (Creature)((Entity)sender).getWorld().spawnEntity(((Entity)sender).getLocation(), EntityType.SKELETON);
            ItemStack weapon = new ItemStack(Material.BOW);
            weapon.addEnchantment(Enchantment.ARROW_DAMAGE, 2);
            this.boss.getEquipment().setItemInHand(weapon);
            this.boss.getEquipment().setHelmet(new ItemStack(Material.IRON_HELMET));
            this.boss.getEquipment().setChestplate(new ItemStack(Material.IRON_CHESTPLATE));
            this.boss.getEquipment().setLeggings(new ItemStack(Material.IRON_LEGGINGS));
            this.boss.getEquipment().setBoots(new ItemStack(Material.IRON_BOOTS));
            this.updateBossHealthGauge();
            this.boss.setCustomNameVisible(true);
            this.boss.setMaxHealth((double)(100 * this.level));
            this.boss.setHealth(this.boss.getMaxHealth());
            int speed = this.level <= 20 ? 2 : 3;
            this.boss.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 72000, speed, false));
            this.boss.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 72000, 1, false));
            this.boss.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 72000, 1, false));
            this.boss.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 72000, 1, false));
            this.boss.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 72000, 1, false));
            this.boss.setRemoveWhenFarAway(false);
            this.getServer().broadcastMessage(ChatColor.YELLOW + "\u90aa\u60aa\u306a\u5b58\u5728\u304c\u3053\u306e\u5730\u306b\u821e\u3044\u964d\u308a\u305f\u2026");
            this.boss.getWorld().playSound(this.boss.getLocation(), Sound.PORTAL_TRAVEL, 100.0f, 1.0f);
            new BossEffect(this.boss).runTaskTimer((Plugin)this, 0L, 5L);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent e) {
        if (e.getEntity().equals(this.boss)) {
            if (e.getDamager() instanceof Arrow && this.boss.equals(((Arrow)e.getDamager()).getShooter())) {
                e.setCancelled(true);
                return;
            }
            if (rand.nextInt(3) == 0) {
                this.boss.getWorld().playSound(this.boss.getLocation(), Sound.WITHER_SHOOT, 100.0f, (float)(0.5 + (double)rand.nextFloat()));
            }
            this.updateBossHealthGauge();
            if (this.skill == null || !this.skill.isRunning()) {
                switch (rand.nextInt(20)) {
                    case 0: {
                        this.skill = new TornadoShot(this, this.level);
                        break;
                    }
                    case 1: {
                        this.skill = new MachinegunShot(this, this.level);
                        break;
                    }
                    case 2: {
                        this.skill = new ShowerShot(this, this.level);
                        break;
                    }
                    case 3: {
                        if (!(this.boss.getHealth() / (double)((float)this.boss.getMaxHealth()) < 0.5)) break;
                        this.skill = new ThrowPotion(this, this.level);
                        break;
                    }
                }
            }
        }
    }

    @EventHandler
    public void onEntityDamageByBlockEvent(EntityDamageByBlockEvent e) {
        if (e.getEntity().equals(this.boss)) {
            this.updateBossHealthGauge();
        }
    }

    @EventHandler
    public void onEntityRegainHealthEvent(EntityRegainHealthEvent e) {
        if (e.getEntity().equals(this.boss)) {
            this.updateBossHealthGauge();
        }
    }

    private void updateBossHealthGauge() {
        int remaining = (int)(this.boss.getHealth() / this.boss.getMaxHealth() * (double)HEALTHGAUGE.length());
        this.boss.setCustomName("\u30b4\u30eb\u30b4\u30fb\u30b5\u30fc\u30c6\u30a3\u30ef\u30f3 " + ChatColor.GREEN + HEALTHGAUGE.substring(0, remaining) + ChatColor.DARK_RED + HEALTHGAUGE.substring(remaining) + ChatColor.RESET);
    }

    @EventHandler
    public void onEntityDeathEvent(EntityDeathEvent e) {
        if (e.getEntity().equals(this.boss)) {
            this.boss.getWorld().playSound(this.boss.getLocation(), Sound.WITHER_DEATH, 100.0f, 1.0f);
            if (this.skill != null && this.skill.isRunning()) {
                this.skill.cancel();
            }
            int n = 0;
            while (n != this.level / 10 + 1) {
                Location loc = this.boss.getLocation();
                loc.add((double)(rand.nextInt(10) - 5), 1.0, (double)(rand.nextInt(10) - 5));
                loc.getWorld().dropItem(loc, new ItemStack(Material.DIAMOND, 1 + rand.nextInt(16)));
                ++n;
            }
            e.setDroppedExp(this.level * 500);
            this.getServer().broadcastMessage(ChatColor.YELLOW + "\u90aa\u60aa\u306a\u5b58\u5728\u306f\u52c7\u8005\u306b\u3088\u308a\u8a0e\u4f10\u3055\u308c\u305f\u2026");
            this.boss = null;
        }
    }

    @EventHandler
    public void onChunkUnloadEvent(ChunkUnloadEvent e) {
        if (this.boss != null && !this.boss.isDead() && e.getChunk().equals(this.boss.getLocation().getBlock().getChunk())) {
            e.setCancelled(true);
        }
    }

    public static Random getRandom() {
        return rand;
    }

    public Creature getBoss() {
        return this.boss;
    }
}

