/*
 * Decompiled with CFR 0.152.
 */
package jp.jias.bukkit.bossmonster;

import java.util.ArrayList;
import jp.jias.bukkit.bossmonster.BossMonster;
import jp.jias.bukkit.bossmonster.RemoveEntities;
import jp.jias.bukkit.bossmonster.Skill;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public class MachinegunShot
extends Skill {
    private int shot;
    private int amount;

    public MachinegunShot(BossMonster plugin, int level) {
        super(plugin);
        this.amount = 10 + level * 5;
        this.shot = level <= 20 ? 1 : 1 + (level - 20) / 20;
        int interval = level <= 10 ? 2 : 1;
        this.getBoss().getServer().broadcastMessage(ChatColor.GOLD + "\u30de\u30b7\u30f3\u30ac\u30f3\u30b7\u30e7\u30c3\u30c8\uff01");
        this.runTaskTimer((Plugin)plugin, 30L, interval);
    }

    @Override
    protected void fire() {
        ArrayList<Entity> arrows = new ArrayList<Entity>();
        Location loc = this.getBoss().getLocation().add(0.0, 1.0, 0.0);
        int n = 0;
        while (n != this.shot) {
            Arrow arrow = loc.getWorld().spawnArrow(loc.add(loc.getDirection()), loc.getDirection(), 1.0f, 12.0f);
            arrows.add((Entity)arrow);
            arrow.setShooter((LivingEntity)this.getBoss());
            this.amount -= this.shot;
            if (this.amount <= 0) {
                this.cancel();
            }
            ++n;
        }
        this.getBoss().getWorld().playEffect(this.getBoss().getLocation(), Effect.BOW_FIRE, 0);
        new RemoveEntities(arrows).runTaskLater((Plugin)this.plugin, 100L);
    }
}

