/*
 * Decompiled with CFR 0.152.
 */
package jp.jias.bukkit.bossmonster;

import java.util.ArrayList;
import jp.jias.bukkit.bossmonster.BossMonster;
import jp.jias.bukkit.bossmonster.RemoveEntities;
import jp.jias.bukkit.bossmonster.Skill;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ShowerShot
extends Skill {
    private int amount;

    public ShowerShot(BossMonster plugin, int level) {
        super(plugin);
        this.amount = 3 + level / 5;
        int interval = level <= 10 ? 10 : 5;
        this.getBoss().getServer().broadcastMessage(ChatColor.GOLD + "\u30b7\u30e3\u30ef\u30fc\u30b7\u30e7\u30c3\u30c8\uff01");
        this.runTaskTimer((Plugin)plugin, 30L, interval);
    }

    @Override
    protected void fire() {
        ArrayList<Entity> arrows = new ArrayList<Entity>();
        Location loc = this.getBoss().getLocation().add(0.0, 2.5, 0.0);
        loc.getWorld().playEffect(loc, Effect.BOW_FIRE, 0);
        int angle = 0;
        while (angle != 360) {
            Vector v = new Vector(Math.sin(Math.toRadians(angle)) / 50.0, 1.0, Math.cos(Math.toRadians(angle)) / 50.0).normalize();
            Arrow arrow = this.getBoss().getWorld().spawnArrow(loc, v, 2.0f, 12.0f);
            arrows.add((Entity)arrow);
            arrow.setShooter((LivingEntity)this.getBoss());
            if (BossMonster.getRandom().nextInt(10) == 0) {
                arrow.setFireTicks(200);
            }
            angle += 10;
        }
        new RemoveEntities(arrows).runTaskLater((Plugin)this.plugin, 160L);
        --this.amount;
        if (this.amount == 0) {
            this.cancel();
        }
    }
}

