/*
 * Decompiled with CFR 0.152.
 */
package jp.jias.bukkit.bossmonster;

import java.util.ArrayList;
import jp.jias.bukkit.bossmonster.BossMonster;
import jp.jias.bukkit.bossmonster.RemoveEntities;
import jp.jias.bukkit.bossmonster.Skill;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class TornadoShot
extends Skill {
    private int amount;
    private int angleInterval;
    private int shot;
    private int angle = 0;

    public TornadoShot(BossMonster plugin, int level) {
        super(plugin);
        this.angleInterval = level <= 10 ? 10 : 20;
        this.shot = level <= 20 ? 5 : 10;
        this.amount = (1 + level / 20) * 36;
        this.getBoss().getServer().broadcastMessage(ChatColor.GOLD + "\u30c8\u30eb\u30cd\u30fc\u30c9\u30b7\u30e7\u30c3\u30c8\uff01");
        this.runTaskTimer((Plugin)plugin, 30L, 1L);
    }

    @Override
    protected void fire() {
        ArrayList<Entity> arrows = new ArrayList<Entity>();
        this.angle += this.angleInterval;
        Location loc = this.getBoss().getLocation();
        loc.setYaw((float)(-this.angle));
        this.getBoss().teleport(loc);
        loc.add(0.0, (double)1.3f, 0.0);
        loc.getWorld().playEffect(loc, Effect.BOW_FIRE, 0, this.angle);
        int n = 0;
        while (n != this.shot) {
            Vector v = new Vector(Math.sin(Math.toRadians(this.angle)), (double)((float)n / 10.0f), Math.cos(Math.toRadians(this.angle))).normalize();
            Arrow arrow = this.getBoss().getWorld().spawnArrow(loc.add(v), v, 0.6f, 12.0f);
            arrow.setShooter((LivingEntity)this.getBoss());
            arrows.add((Entity)arrow);
            ++n;
        }
        new RemoveEntities(arrows).runTaskLater((Plugin)this.plugin, 140L);
        --this.amount;
        if (this.amount == 0) {
            this.cancel();
        }
    }
}

